//Performing KL transform
//Scilab 5.4.1
//Windows 10 
//Requires SIVP, IPD toolboxes

clear;
clc;

X = [3,5,6,7;5,6,3,3;4,6,7,5];
[m,n]= size(X);
A = [];
E = [];
for i =1:n
    A = A+X(:,i);
    E = E+X(:,i)*X(:,i)';
end
mx = A/n;                     //mean matrix
E = E/n;
C = E - mx*mx';             //covariance matrix C = E[xx']-mx*mx'
[V,D] = spec(C);           //eigen values and eigen vectors
d = diag(D);              //diagonal elements od eigen values
[d,i] = gsort(d);        //sorting the elements of D in descending order
for j = 1:length(d)
    T(:,j)= V(:,i(j));
end
T =T'
disp(d,'Eigen Values are U = ')
disp(T,'The eigen vector matrix T =')
disp(T,'The KL tranform basis is =')

//KL transform
for i = 1:n
    Y(:,i)= T*X(:,i);
end
disp(Y,'KL transformation of the input matrix Y =')

//Reconstruction
for i = 1:n
    x(:,i)= T'*Y(:,i);
end
disp(x,'Reconstruct matrix of the given sample matrix X =')

//Output
//  
// Eigen Values are U =    
// 
//    3.6278623  
//    1.0409979  
//    0.4561398  
// 
// The eigen vector matrix T =   
// 
//    0.7383786  - 0.5693168    0.3614907  
//    0.0603190    0.5896337    0.8054152  
//    0.6716835    0.5728966  - 0.4697135  
// 
// The KL tranform basis is =   
// 
//    0.7383786  - 0.5693168    0.3614907  
//    0.0603190    0.5896337    0.8054152  
//    0.6716835    0.5728966  - 0.4697135  
// 
// KL transformation of the input matrix Y =   
// 
//    0.8145143    2.444936     5.2527556    5.2681528  
//    6.3507865    8.6718888    7.7687219    6.2182105  
//    3.0006794    3.977516     2.4607962    4.0719067  
// 
// Reconstruct matrix of the given sample matrix X =   
// 
//    3.    5.    6.    7.  
//    5.    6.    3.    3.  
//    4.    6.    7.    5.  
// 
